%% Generate a cell.
% Dmitry Ershov, Nicolas Minc Team at IJM, 2017

% Cell parameters:
cell_params                      = [];          % empty just in case

% Cell files parameters
cell_params.shape_paths          = shape_paths; 
cell_params.body_ind             = 1;            % Id of the body to use for shape input (corresponds to the body and polarity Folder)


% MT forces 
% Force equation : F = L^Beta1 + pullfactor*L^Beta2 + pullfactor_exp*2^(L/Unit_branch)
% If no polarity cap (polarity folder is empty or does not exist):
% Only the first factor (L^Beta1) will be used and both pullfactor/pullfactor_exp 
% will be automatically set to 0.
cell_params.Beta1                = 3;
cell_params.pullfactor           = 0;
cell_params.Beta2                = 2;
cell_params.pullfactor_exp       = 0;
cell_params.Unit_branch          = 6.75;        % experimentally measured in Sea Urchins.

% MT stability parameters (for details read "generating MT spatial stability inout")
% Warning: Gradient is calculated over THE WHOLE 3D IMAGE, not only for the shape;
% thus the 'body_filling_space' parameter matters!
% Yolk concentration gradient parameters:
cell_params.gradyolk             = 0;           % Sharpness of the yolk gradient. 0 if no gradient; cannot be <0. Typical values from 2 (linear gradient) to 50 for a very sharp one. 
cell_params.erfoffset            = 0;       	% Offset of yolk upper limit towards equator of the cell, after infinite time of sedimentation (in pixels). If 0 then half of the cell is yolk. If < 0 less yolk, if > 0 more yolk. Several if several gradients.
cell_params.direction_grad     	 = [90 30];     % Direction of the yolk gradient. n x 2 matrix. Lines are theta and phi (in degrees) of the gradient axis, columns are the number of gradients.

cell_params.MTstab               = 1;           % MT stability in yolk; has no effect if there is no yolk.



% Aster parameters
cell_params.anglelimit_deg       = 157;                     % Angular extension of the asters; counted from the spindle
cell_params.theta                = randsample(0:180, 1);    % Starting theta, degrees. Random from 1 to 180: randsample(0:180, 1) 
cell_params.phi                  = randsample(0:180, 1);    % Starting phi, degrees. . Random from 1 to 360: randsample(0:180, 1) 
cell_params.startingxyz          = [40,110,60];           % Starting x, y and z. If empty, the starting position will be the cell centroid.
cell_params.Nucsize              = 15; 	         % Nucleus diameter, ie distance btw centrosomes (in pixels)
cell_params.Nucexcl              = 1.2;   	     % Nucexcl can't be < 1. Nucleus exclusion size: it be used to estimate if the nucleus is inside/outside the cell. Nucl.est.size = Nucsize * Nucexcl/2 




% make cell instance
current_cell                     = DPP_cell(cell_params);    
current_cell.show      
current_cell.save      

    
    